/* /////////////////////
// Main.js by Radnen  //
////////////////////////
//    Last Updated    //
//   -- 03/12/10 --   //
//  For GOTY Edition  //
///////////////////// */

Rectangle(0, 0, GetScreenWidth(), GetScreenHeight(), CreateColor(0, 0, 0));
GetSystemFont().drawZoomedText(GetScreenWidth()/2-80, GetScreenHeight()/2-15, 3, "Loading...");
FlipScreen();

// Require Scripts //
RequireScript('TileMovementEngine.js');
RequireScript('Menus.js');
RequireScript('Textbox.js');
RequireScript('Menu.js');
RequireScript('Ball.js');
RequireScript('Tiles.js');
RequireScript('Ferry.js');
RequireScript('Traps.js');
RequireScript('Cursor.js');
RequireScript('audio.js');
RequireScript('FadeObject.js');

RequireSystemScript('time.js');
RequireSystemScript('screen.js');
RequireSystemScript('input.js');

var TileMovement = new TileMovementEngine(16);
TileMovement.onTile = On_Tile;
TileMovement.onTileEnter = On_Enter;
TileMovement.onTileLeave = On_Leave;
TileMovement.reposition = false;
TileMovement.directionMethod = METHOD_FRAME;

var SW = GetScreenWidth();
var SH = GetScreenHeight();
var White = CreateColor(255, 255, 255);
var Blue  = CreateColor(20 , 75 , 240);
var Black = CreateColor(0  , 0  , 0  );
var RedC  = CreateColor(255, 0  , 0  , 125);

var font = LoadFont('Afont3.rfn');
var TitleImg = LoadImage('Jump.png');
var Title = new FadeImage(TitleImg);
var RadnenImg = LoadImage('Radnen.png');
var Radnen = new FadeImage(RadnenImg);
var BG  = new FadeImage(LoadImage('BG.png'));
BG.originalFade = -1; BG.fadev = -1;
var BG2 = new FadeImage(LoadImage('BG2.png'));
var BG3 = new FadeImage(LoadImage('BG3.png'));
var BG4 = new FadeImage(LoadImage('BG4.png'));
BG4.originalFade = -1; BG4.fadev = -1;
var Overhead = LoadImage('Overhead.png');
var Twinkle = LoadImage('Twinkle.png');
var CreditPlane = new FadeImage(LoadImage('CreditPlane.png'));
var OptionPlane = new FadeImage(LoadImage('OptionPlane.png'));
OptionPlane.yv = -SH; OptionPlane.newY = -SH; OptionPlane.yamt = 4;
var TileType = "TileAnimate.rss";
var Level = 1;
var GameSpeed = 60;
var SpecialFX = true;
var ThrottleFrameRate = true;
var Player = {};
var TitleMusic = LoadSound('hyo-vile.it');
var Mouse = new Cursor("Mouse.png");

// Main Function //
function game()
{
	LoadOptions();
	BindKey(KEY_ESCAPE, '', '');
	SetFrameRate(0);
	ChangeMusic(TitleMusic);
	font.drawZoomedText(SW/2-font.getStringWidth("Radnen Presents"),SH/2-20,2,"Radnen Presents");
	FadeIn(1000);
	FadeOut(1000);
	BG2.blit(0,0);
	Overhead.blit(0,0);
	FadeIn(1000);
	Delay(250);
	Title.slideFrom(SW/2-Title.img.width/2,64);
	Title.slideTo(SW/2-Title.img.width/2,64);
	Title.slide(750);
	Delay(250);
	Radnen.slideFrom(8,SH+Radnen.img.height+4);
	Radnen.slideTo(8,SH-Radnen.img.height-4);
	Radnen.slide(500);
	Delay(250);
	Title.reset(); Radnen.reset(); Title.yv = -8;
	BG2.reset();
	SetFrameRate(GameSpeed);
	GameMenu();
}

function PlayGame()
{
	Level = 1;
	SetFrameRate(0);
	BG3.blit(0,0);
	Overhead.blit(0,0);
	FadeIn(2000);
	var text = "Many ages ago there were tombs made for\nancient kings. " +
	"Just recently these tombs were found by a round ball. Fortunately, he \n" +
	"has the ability to jump away from each tile\nand trap. And so his quest " +
	"begins, to search for the hidden treasures said to have been hid deep " +
	"inside these tombs..."
	SetFrameRate(GameSpeed);
	TextWindow(64,128,SW-128,SH-256,text,true);
	FadeOut(2000);
	StopMusic();
	CreateBall();
	SetFrameRate(0);
	if(!IsMapEngineRunning()) MapEngine("Level_01.rmp",GameSpeed);
	else ChangeMap("Level_01.rmp");
}

function CreateBall()
{
	Player = new Ball();
	SetFrameRate(0);
	var name = Player.name;
	if(!DoesPersonExist(name)) CreatePerson(name, "Ball.rss", false);
	TileMovement.attachInput(name);
	AttachCamera(name);
	SetPersonSpeed(name, 2);
	SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, 'MapEntry();');
	SetDefaultMapScript(SCRIPT_ON_LEAVE_MAP, 'MapLeave();');
	SetUpdateScript('Update()');
	SetRenderScript('Render()');
}

function Render()
{
	Player.renderHealthBar();
	DrawCurrentSong();
	font.setColorMask(White);
	if (Player.showLives) font.drawText(0, 0, "Lives: " + Player.lives);
	font.drawText(SW - font.getStringWidth("Level: " + Level), 0, "Level: " + Level);
	Mouse.draw();
}

function Update()
{
	TileMovement.update();
	Player.update();
	Mouse.update();
	if (IsKeyPressed(KEY_ESCAPE)) InGameMenu();

	// Instead use mouse //
	var xdist = GetMouseXDistance();
	var ydist = GetMouseYDistance();
	var Mouse2Away = (xdist > 2 || ydist > 2);
	var Mouse1Away = (xdist == 2 || ydist == 2);
	var MouseAtPlayer = (xdist == 1 && ydist == 1);
	var MX = Mouse.x;
	var MY = Mouse.y;

	if (!MouseAtPlayer && !Mouse.idle && !TileMovement.postMovement || Mouse.pressed) {
		if (MY > Player.y && MX > Player.x-16 && MX < Player.x+16) SetPersonDirection(Player.name, "south");
		if (MY < Player.y && MX > Player.x-16 && MX < Player.x+16) SetPersonDirection(Player.name, "north");
		if (MX > Player.x && MY > Player.y-16 && MY < Player.y+16) SetPersonDirection(Player.name, "east");
		if (MX < Player.x && MY > Player.y-16 && MY < Player.y+16) SetPersonDirection(Player.name, "west");
	}

	if (IsMouseButtonPressed(MOUSE_LEFT) && !Player.jumping && Mouse2Away && !TileMovement.isPaused() && !Mouse.pressed) {
		MovedByMouse = true;
		Jump();
	}

	if (IsMouseButtonPressed(MOUSE_LEFT) && !Player.jumping && Mouse1Away && !TileMovement.postMovement && !TileMovement.isPaused()) {
		if (!Player.dead && !MouseAtPlayer) {
			TileMovement.move(Player.direction);
			MovedByMouse = true;
			Mouse.pressed = true;
		}
	}

	if (IsMouseButtonPressed(MOUSE_LEFT) && Mouse.pressed && !TileMovement.postMovement) {
		if (!Player.dead && !MouseAtPlayer) {
			TileMovement.move(Player.direction);
			MovedByMouse = true;
		}
	}

	if (IsKeyPressed(KEY_SPACE) && !Player.jumping && !TileMovement.isPaused()) Jump();

	if (IsKeyPressed(KEY_CTRL)) TileMovement.pauseEngine();
	else TileMovement.unpauseEngine();

	if (TileMovement.isPaused()) {
		if (IsKeyPressed(KEY_UP))    SetPersonDirection(Player.name, "north");
		if (IsKeyPressed(KEY_DOWN))  SetPersonDirection(Player.name, "south");
		if (IsKeyPressed(KEY_LEFT))  SetPersonDirection(Player.name, "west");
		if (IsKeyPressed(KEY_RIGHT)) SetPersonDirection(Player.name, "east");
	}

	if (Player.death) {
		SetPersonScript(Player.name, SCRIPT_COMMAND_GENERATOR, '');
		TextWindow(3, 3, SW-6, 24, "Oh no! You have died, Game Over!");
		Player.lives--;
		Player.health = Player.maxhealth;
		Player.death = false;
		RestartMenu();
	}
	PlaySongList();
}

function Jump()
{
	if(!TileMovement.postMovement)
	{
		var Direction = Player.direction;
		Player.jumping = true;
		SetPersonSpeed(TileMovement.input, 4);
		if (Direction == "north") TileMovement.move("north", 1);
		if (Direction == "south") TileMovement.move("south", 1);
		if (Direction == "east") TileMovement.move("east", 1);
		if (Direction == "west") TileMovement.move("west", 1);
	}
}

function MapEntry()
{
	CountTiles();
	for (var i = 0; i < 10; ++i)
	{
		if(DoesPersonExist("SpikeTrap_" + i))
			SetPersonScript("SpikeTrap_" + i,SCRIPT_COMMAND_GENERATOR,'Animate()');
		if(DoesPersonExist("BlockTrap_" + i))
			SetPersonScript("BlockTrap_" + i,SCRIPT_COMMAND_GENERATOR,'Animate()');
	}
}

function MapLeave()
{
	Ferries = [];
	TileAnims = [];
	TileAnim = 0;
}


function Animate()
{
	QueuePersonCommand(GetCurrentPerson(), COMMAND_ANIMATE, true);
}

function DoesPersonExist(name)
{
	var personList = GetPersonList();
	var i = personList.length;
	while (i--) {
		if (name == personList[i]) return true;
	}
	return false;
}

// 64 - 104   = -40   , we get a negative
// |40|       =  40   , we get the absolute value.
// 40 + 16    =  56   , now add player offset distance
// 56 / 32    =   1.75, find in tile,
// 1.75rndUP  =   2   : (2 tiles away from player);

function GetMouseXDistance()
{
	var MouseXDelta = Math.abs(Mouse.x - Player.x); // return as positive.
	return Math.ceil((MouseXDelta+16) / 32); // return as divided by tile to the nearest whole number.
}

function GetMouseYDistance()
{
	var MouseYDelta = Math.abs(Mouse.y - Player.y); // return as positive.
	return Math.ceil((MouseYDelta+16) / 32);
}